% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_log.R
\name{parse_beast_log}
\alias{parse_beast_log}
\title{Parses a BEAST2 \code{.log} output file}
\usage{
parse_beast_log(filename)
}
\arguments{
\item{filename}{name of the BEAST2 .log output file}
}
\value{
data frame with the parameter estimates
}
\description{
Parses a BEAST2 \code{.log} output file
}
\examples{
  log_filename <- get_tracerer_path("beast2_example_output.log")
  estimates <- parse_beast_log(filename = log_filename)
  expected_names <- c(
    "Sample", "posterior", "likelihood",
    "prior", "treeLikelihood", "TreeHeight",
    "BirthDeath", "birthRate2", "relativeDeathRate2"
  )
  testit::assert(names(estimates) == expected_names)
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-in from
  the returned parameter estimates.
  Use \code{\link{save_beast_estimates}} to save the estimates
  to a \code{.log} file.
}
\author{
Richèl J.C. Bilderbeek
}
