% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_istft}
\alias{torch_istft}
\title{Istft}
\usage{
torch_istft(
  self,
  n_fft,
  hop_length = NULL,
  win_length = NULL,
  window = list(),
  center = TRUE,
  normalized = FALSE,
  onesided = NULL,
  length = NULL,
  return_complex = FALSE
)
}
\arguments{
\item{self}{(Tensor) The input tensor. Expected to be output of \code{\link[=torch_stft]{torch_stft()}},
can either be complex (\code{channel}, \code{fft_size}, \code{n_frame}), or real
(\code{channel}, \code{fft_size}, \code{n_frame}, 2) where the \code{channel} dimension is
optional.}

\item{n_fft}{(int) Size of Fourier transform}

\item{hop_length}{(Optional\verb{[int]}) The distance between neighboring sliding window frames.
(Default: \code{n_fft \%\% 4})}

\item{win_length}{(Optional\verb{[int]}) The size of window frame and STFT filter.
(Default: \code{n_fft})}

\item{window}{(Optional(torch.Tensor)) The optional window function.
(Default: \code{torch_ones(win_length)})}

\item{center}{(bool) Whether \code{input} was padded on both sides so that the
\eqn{t}-th frame is centered at time \eqn{t \times \mbox{hop\_length}}.
(Default: \code{TRUE})}

\item{normalized}{(bool) Whether the STFT was normalized. (Default: \code{FALSE})}

\item{onesided}{(Optional(bool)) Whether the STFT was onesided.
(Default: \code{TRUE} if \code{n_fft != fft_size} in the input size)}

\item{length}{(Optional(int)]) The amount to trim the signal by (i.e. the
original signal length). (Default: whole signal)}

\item{return_complex}{(Optional(bool)) Whether the output should be complex,
or if the input should be assumed to derive from a real signal and window.
Note that this is incompatible with \code{onesided=TRUE}. (Default: \code{FALSE})}
}
\description{
Inverse short time Fourier Transform. This is expected to be the inverse of \code{\link[=torch_stft]{torch_stft()}}.
}
\details{
It has the same parameters (+ additional optional parameter of \code{length}) and it should return the
least squares estimation of the original signal. The algorithm will check using the NOLA
condition (nonzero overlap).

Important consideration in the parameters \code{window} and \code{center} so that the envelop
created by the summation of all the windows is never zero at certain point in time. Specifically,
\eqn{\sum_{t=-\infty}^{\infty} |w|^2(n-t\times hop_length) \neq 0}.

Since \code{\link[=torch_stft]{torch_stft()}} discards elements at the end of the signal if they do not fit in a frame,
\code{istft} may return a shorter signal than the original signal (can occur if \code{center} is FALSE
since the signal isn't padded).

If \code{center} is \code{TRUE}, then there will be padding e.g. \code{'constant'}, \code{'reflect'}, etc.
Left padding can be trimmed off exactly because they can be calculated but right
padding cannot be calculated without additional information.

Example: Suppose the last window is:
\verb{[c(17, 18, 0, 0, 0)} vs \code{c(18, 0, 0, 0, 0)}

The \code{n_fft}, \code{hop_length}, \code{win_length} are all the same which prevents the calculation
of right padding. These additional values could be zeros or a reflection of the signal so providing
\code{length} could be useful. If \code{length} is \code{None} then padding will be aggressively removed
(some loss of signal).

D. W. Griffin and J. S. Lim, "Signal estimation from modified short-time Fourier transform,"
IEEE Trans. ASSP, vol.32, no.2, pp.236-243, Apr. 1984.
}
