% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_tokens.r
\name{category_highlight_tokens}
\alias{category_highlight_tokens}
\title{Highlight tokens per category}
\usage{
category_highlight_tokens(
  tokens,
  category,
  labels = NULL,
  alpha = 0.4,
  class = NULL,
  colors = NULL,
  unfold = NULL,
  span_adjacent = F,
  doc_id = NULL
)
}
\arguments{
\item{tokens}{A character vector of tokens}

\item{category}{Either a factor, or a numeric vector with values representing category indices. If a numeric vector is used, labels must also be given}

\item{labels}{A character vector with labels for the categories}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully transparent and 1 being
fully colored. This can be a vector to specify a different alpha for each value.}

\item{class}{Optionally, a character vector of the class to add to the span tags. If NA no class is added}

\item{colors}{A character vector with color names for unique values of the value argument. Has to be the same length
as unique(na.omit(category))}

\item{unfold}{Either a character vector or a named list of vectors of the same length as tokens. If given, all tokens with a tag can be clicked on to unfold the given text. If a list of vectors is given,
 the values of the columns are concatenated with the column name. E.g. list(doc_id = 1, sentence = 1) will be [doc_id = 1, sentence = 2].
This only works if the tagged tokens are used in the html browser created with the \code{\link{create_browser}} function (as it relies on javascript).}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}

\item{doc_id}{If span_adjacent is TRUE, The document ids are required to ensure that tags do not span from one document to another.}
}
\value{
a character vector of color-tagged tokens
}
\description{
This is a convenience wrapper for tag_tokens() that can be used if tokens need to be colored per category
}
\examples{
tokens = c('token_1','token_2','token_3','token_4')
category = c('a','a',NA,'b')
category_highlight_tokens(tokens, category)
}
