% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize.r
\name{scale_col}
\alias{scale_col}
\title{Create a scale color for a html style attribute}
\usage{
scale_col(value, alpha = 1, col_range = c("red", "blue"))
}
\arguments{
\item{value}{A numeric vector with values between -1 and 1. Determines the color mixture
of the scale colors specified in col_range}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully
transparent and 1 being fully colored. This can be a vector to specify a
different alpha for each value.}

\item{col_range}{The colors used in the scale.}
}
\value{
The string used to specify a color in a html tag attribute
}
\description{
Designed to be used together with the attr_style function. The return value
can directly be used to set the color in an html tag attribute (e.g., color, background-color)
}
\examples{
scale_col(c(NA, -1, 0, 0.5, 1))

## used in combination with attr_style()
attr_style(color = scale_col(c(NA, -1, 0, 0.5, 1)))

## note that for background-color you need inversed
## quotes to deal with the hyphen in an argument name
attr_style(`background-color` = scale_col(c(NA, -1, 0, 0.5, 1)))

tag_attr(class = c(1, 2),
         style = attr_style(`background-color` = scale_col(c(-1,1))))
}
