% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers_aux.R
\name{tm_basemap}
\alias{tm_basemap}
\alias{tm_tiles}
\title{Map layer: basemap / overlay tiles}
\usage{
tm_basemap(
  server = NA,
  alpha = NULL,
  zoom = NULL,
  max.native.zoom = 17,
  zindex = 0,
  group = NA,
  group.control = "radio"
)

tm_tiles(
  server = NA,
  alpha = NULL,
  zoom = NULL,
  max.native.zoom = 17,
  zindex = NA,
  group = NA,
  group.control = "check"
)
}
\arguments{
\item{server}{Name of the provider or an URL. The list of available providers
can be obtained with \code{providers} (tip: in RStudio, type \verb{leaflet::providers$} to see
the options). See \url{https://leaflet-extras.github.io/leaflet-providers/preview/}
for a preview of those. When a URL is provided, it should be in template format,
e.g. \code{"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png"}.
Use \code{NULL} in \code{tm_basemap()} to disable basemaps.}

\item{alpha}{Transparency level}

\item{zoom}{Zoom level (only used in plot mode)}

\item{max.native.zoom}{Maximum native zoom level (only used in view mode).
The minimum and maximum zoom levels are determined in \code{tm_view()}.}

\item{zindex}{zindex of the pane in view mode. By default, it is set to the
layer number plus 400. By default, the tmap layers will therefore be placed
in the custom panes \code{"tmap401"}, \code{"tmap402"}, etc., except for the base tile
layers, which are placed in the standard \code{"tile"}. This parameter determines
both the name of the pane and the z-index, which determines the pane order
from bottom to top. For instance, if \code{zindex} is set to 500, the pane will
be named \code{"tmap500"}.}

\item{group}{Name of the group to which this layer belongs. This is only
relevant in view mode, where layer groups can be switched (see \code{group.control})}

\item{group.control}{In view mode, the group control determines how layer
groups can be switched on and off. Options: \code{"radio"} for radio buttons
(meaning only one group can be shown), \code{"check"} for check boxes
(so multiple groups can be shown), and \code{"none"} for no control
(the group cannot be (de)selected).}
}
\description{
Map layer that draws tiles from a tile server. \code{tm_basemap()} draws the tile
layer as basemap, i.e. as bottom layer. In contrast, \code{tm_tiles()} draws the
tile layer as overlay layer, where the stacking order corresponds with the
order in which this layer is called, just like other map layers.
}
\examples{
\dontrun{
if (requireNamespace("maptiles")) {
	# view mode
	current_mode = tmap_mode("view")
	tm_basemap("Stadia.StamenWatercolor") +
		tm_shape(World) +
		tm_polygons(
		  "HPI",
		  fill.scale = tm_scale(values = "reds"),
		  fill_alpha.scale = 0.5)

	tm_shape(World, crs = "+proj=eqearth") +
		tm_polygons(
			"HPI",
			fill.scale = tm_scale(values = "reds"),
			fill_alpha.scale = 0.5) +
	tm_basemap(NULL)

	# plot mode:
	tmap_mode("plot")
	tm_basemap() +
		tm_shape(World) +
		tm_polygons("HPI")

	tm_basemap("OpenTopoMap") +
		tm_shape(World) +
		tm_polygons(fill = NA, col = "black")

	tm_basemap("CartoDB.PositronNoLabels") +
	tm_shape(NLD_prov, crs = 4236) +
		tm_borders() +
		tm_facets_wrap("name") +
		tm_tiles("CartoDB.PositronOnlyLabels")

	# restore mode
	tmap_mode(current_mode)
}
}
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_basemaps}{Basemap examples}
}
