% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-subset.R
\name{tree_subset}
\alias{tree_subset}
\alias{tree_subset.phylo}
\alias{tree_subset.treedata}
\title{Subset tree objects by related nodes}
\usage{
tree_subset(
  tree,
  node,
  levels_back = 5,
  group_node = TRUE,
  group_name = "group",
  root_edge = TRUE
)

\method{tree_subset}{phylo}(
  tree,
  node,
  levels_back = 5,
  group_node = TRUE,
  group_name = "group",
  root_edge = TRUE
)

\method{tree_subset}{treedata}(
  tree,
  node,
  levels_back = 5,
  group_node = TRUE,
  group_name = "group",
  root_edge = TRUE
)
}
\arguments{
\item{tree}{a tree object of class phylo}

\item{node}{either a tip label or a node number for the given
tree that will be the focus of the subsetted tree}

\item{levels_back}{a number specifying how many nodes back from
the selected node the subsetted tree should include}

\item{group_node}{whether add grouping information of selected node}

\item{group_name}{group name (default 'group') for storing grouping information if group_node = TRUE}

\item{root_edge}{If TRUE (by default), set root.edge to path length of orginal root to the root of subset tree}
}
\description{
This function allows for a tree object to be subset by specifying a
node and returns all related nodes within a selected number of
levels
}
\details{
This function will take a tree and a specified node from
that tree and subset the tree showing all relatives back to a specified
number of nodes. This function allows for a combination of
\code{ancestor} and \code{offspring} to return a subsetted
tree that is of class phylo. This allows for easy graphing of the tree
with \code{ggtree}
}
\examples{
set.seed(123)
tree <- ape::rtree(6)
sub_tree <- tree_subset(tree, node = "t1", levels_back = 2)
}
