% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{format_number}
\alias{format_number}
\alias{format_p_value}
\title{Format numbers or p values}
\usage{
format_number(x, accuracy = 0.1, big.mark = ",", scale_cut = NULL, ...)

format_p_value(x, accuracy = 1e-04)
}
\arguments{
\item{x}{A \code{number} to format.}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{scale_cut}{Named numeric vector that allows you to rescale large
(or small) numbers and add a prefix. Built-in helpers include:
\itemize{
\item \code{cut_short_scale()}: [10^3, 10^6) = K, [10^6, 10^9) = M, [10^9, 10^12) = B, [10^12, Inf) = T.
\item \code{cut_long_scale()}: [10^3, 10^6) = K, [10^6, 10^12) = M, [10^12, 10^18) = B, [10^18, Inf) = T.
\item \code{cut_si(unit)}: uses standard SI units.
}

If you supply a vector \code{c(a = 100, b = 1000)}, absolute values in the
range \verb{[0, 100)} will not be rescaled, absolute values in the range \verb{[100, 1000)}
will be divided by 100 and given the suffix "a", and absolute values in
the range \verb{[1000, Inf)} will be divided by 1000 and given the suffix "b".
If the division creates an irrational value (or one with many digits), the
cut value below will be tried to see if it improves the look of the final
label.}

\item{...}{
  Arguments passed on to \code{\link[scales:number]{scales::number}}
  \describe{
    \item{\code{scale}}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}
    \item{\code{style_positive}}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}}
    \item{\code{style_negative}}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hypen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}}
  }}
}
\value{
Formatted number as \code{character} string.
}
\description{
Format numbers or p values
}
\examples{
format_number(232342.3443)

format_number(232342.3443, accuracy = 0.01)

format_number(232342.3443, accuracy = 1, big.mark = "")

format_p_value(0.03445553)

format_p_value(0.0003445553)

format_p_value(0.00003445553)

}
