% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{new_tidylda}
\alias{new_tidylda}
\title{Construct a new object of class \code{tidylda}}
\usage{
new_tidylda(
  lda,
  dtm,
  burnin,
  is_prediction = FALSE,
  alpha = NULL,
  eta = NULL,
  optimize_alpha = NULL,
  calc_r2 = NULL,
  calc_likelihood = NULL,
  call = NULL,
  threads
)
}
\arguments{
\item{lda}{list output of \code{\link[tidylda]{fit_lda_c}}}

\item{dtm}{a document term matrix or term co-occurrence matrix of class \code{dgCMatrix}}

\item{burnin}{integer number of burnin iterations.}

\item{is_prediction}{is this for a prediction (as opposed to initial fitting,
or update)? Defaults to \code{FALSE}}

\item{alpha}{output of \code{\link[tidylda]{format_alpha}}}

\item{eta}{output of \code{\link[tidylda]{format_eta}}}

\item{optimize_alpha}{did you optimize \code{alpha} when making a call to
\code{\link[tidylda]{fit_lda_c}}?  If \code{is_prediction = TRUE}, this
argument is ignored.}

\item{calc_r2}{did the user want to calculate R-squared when calculating the
the model? If \code{is_prediction = TRUE}, this argument is ignored.}

\item{calc_likelihood}{did you calculate the log likelihood when making a call
to \code{\link[tidylda]{fit_lda_c}}?  If \code{is_prediction = TRUE}, this
argument is ignored.}

\item{call}{the result of calling \code{\link[base]{match.call}} at the top of
\code{\link[tidylda]{tidylda}}.}

\item{threads}{number of parallel threads}
}
\value{
Returns an S3 object of class \code{tidylda} with the following slots:

  \code{beta} is a numeric matrix whose rows are the posterior estimates
    of P(token|topic)

  \code{theta} is a numeric matrix  whose rows are the posterior estimates of
    P(topic|document)

  \code{lambda} is a numeric matrix whose rows are the posterior estimates of
    P(topic|token), calculated using Bayes's rule.
    See \code{\link[tidylda]{calc_lambda}}.

  \code{alpha} is the prior for topics over documents. If \code{optimize_alpha}
    is \code{FALSE}, \code{alpha} is what the user passed when calling
    \code{\link[tidylda]{tidylda}}. If \code{optimize_alpha} is \code{TRUE},
    \code{alpha} is a numeric vector returned in the \code{alpha} slot from a
    call to \code{\link[tidylda]{fit_lda_c}}.

  \code{eta} is the prior for tokens over topics. This is what the user passed
    when calling \code{\link[tidylda]{tidylda}}.

  \code{summary} is the result of a call to \code{\link[tidylda]{summarize_topics}}

  \code{call} is the result of \code{\link[base]{match.call}} called at the top
    of \code{\link[tidylda]{tidylda}}

  \code{log_likelihood} is a \code{\link[tibble]{tibble}} whose columns are
    the iteration and log likelihood at that iteration. This slot is only populated
    if \code{calc_likelihood = TRUE}

  \code{r2} is a numeric scalar resulting from a call to
    \code{\link[mvrsquared]{calc_rsquared}}. This slot only populated if
    \code{calc_r2 = TRUE}
}
\description{
Since all three of \code{\link[tidylda]{tidylda}},
  \code{\link[tidylda]{refit.tidylda}}, and
  \code{\link[tidylda]{predict.tidylda}} call \code{\link[tidylda]{fit_lda_c}},
  we need a way to format the resulting posteriors and other user-facing
  objects consistently. This function does that.
}
\note{
In general, the arguments of this function should be what the user passed
  when calling \code{\link[tidylda]{tidylda}}.

  \code{burnin} is used only to determine whether or not burn in iterations
  were used when fitting the model. If \code{burnin > -1} then posteriors
  are calculated using \code{lda$Cd_mean} and \code{lda$Cv_mean} respectively.
  Otherwise, posteriors are calculated using \code{lda$Cd_mean} and
  \code{lda$Cv_mean}.

  The class of \code{call} isn't checked. It's just passed through to the
  object returned by this function. Might be useful if you are using this
  function for troubleshooting or something.
}
\keyword{internal}
