% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_cluster.R
\name{tune_cluster}
\alias{tune_cluster}
\alias{tune_cluster.cluster_spec}
\alias{tune_cluster.workflow}
\title{Model tuning via grid search}
\usage{
tune_cluster(object, ...)

\method{tune_cluster}{cluster_spec}(
  object,
  preprocessor,
  resamples,
  ...,
  param_info = NULL,
  grid = 10,
  metrics = NULL,
  control = tune::control_grid()
)

\method{tune_cluster}{workflow}(
  object,
  resamples,
  ...,
  param_info = NULL,
  grid = 10,
  metrics = NULL,
  control = tune::control_grid()
)
}
\arguments{
\item{object}{A \code{tidyclust} model specification or a \code{\link[workflows:workflow]{workflows::workflow()}}.}

\item{...}{Not currently used.}

\item{preprocessor}{A traditional model formula or a recipe created using
\code{\link[recipes:recipe]{recipes::recipe()}}.}

\item{resamples}{An \code{rset()} object.}

\item{param_info}{A \code{\link[dials:parameters]{dials::parameters()}} object or \code{NULL}. If none is given,
a parameters set is derived from other arguments. Passing this argument can
be useful when parameter ranges need to be customized.}

\item{grid}{A data frame of tuning combinations or a positive integer. The
data frame should have columns for each parameter being tuned and rows for
tuning parameter candidates. An integer denotes the number of candidate
parameter sets to be created automatically.}

\item{metrics}{A \code{\link[=cluster_metric_set]{cluster_metric_set()}} or \code{NULL}.}

\item{control}{An object used to modify the tuning process. Defaults to
\code{tune::control_grid()}.}
}
\value{
An updated version of \code{resamples} with extra list columns for
\code{.metrics} and \code{.notes} (optional columns are \code{.predictions} and
\code{.extracts}). \code{.notes} contains warnings and errors that occur during
execution.
}
\description{
\code{\link[=tune_cluster]{tune_cluster()}} computes a set of performance metrics (e.g. accuracy or
RMSE) for a pre-defined set of tuning parameters that correspond to a model
or recipe across one or more resamples of the data.
}
\examples{
library(recipes)
library(rsample)
library(workflows)
library(tune)

rec_spec <- recipe(~., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_pca(all_numeric_predictors())

kmeans_spec <- k_means(num_clusters = tune())

wflow <- workflow() \%>\%
  add_recipe(rec_spec) \%>\%
  add_model(kmeans_spec)

grid <- tibble(num_clusters = 1:3)

set.seed(4400)
folds <- vfold_cv(mtcars, v = 2)

res <- tune_cluster(
  wflow,
  resamples = folds,
  grid = grid
)
res

collect_metrics(res)
}
