% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_nrc.R
\name{lexicon_nrc}
\alias{lexicon_nrc}
\title{NRC word-emotion association lexicon}
\source{
\url{http://saifmohammad.com/WebPages/lexicons.html}
}
\usage{
lexicon_nrc(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}

\item{manual_download}{Logical, set \code{TRUE} if you have manually
downloaded the file and placed it in the folder designated by running
this function with \code{return_path = TRUE}.}
}
\value{
A tibble with 13,901 rows and 2 variables:
\describe{
  \item{word}{An English word}
  \item{sentiment}{Indicator for sentiment or emotion: "negative",
  "positive", "anger", "anticipation", "disgust", "fear", "joy", "sadness",
  "surprise", or "trust"}
}
}
\description{
General purpose English sentiment/emotion lexicon. This lexicon labels words
with six possible sentiments or emotions: "negative", "positive", "anger",
"anticipation", "disgust", "fear", "joy", "sadness", "surprise", or "trust".
The annotations were manually done through Amazon's Mechanical Turk.
}
\details{
License required for commercial use. Please contact Saif M. Mohammad
(saif.mohammad@nrc-cnrc.gc.ca).

Citation info:

This dataset was published in Saif Mohammad and Peter Turney. (2013),
``Crowdsourcing a Word-Emotion Association Lexicon.'' Computational
Intelligence, 29(3): 436-465.

article\{mohammad13, \cr
author = \{Mohammad, Saif M. and Turney, Peter D.\}, \cr
title = \{CROWDSOURCING A WORD–EMOTION ASSOCIATION LEXICON\}, \cr
journal = \{Computational Intelligence\}, \cr
volume = \{29\}, \cr
number = \{3\}, \cr
pages = \{436-465\}, \cr
doi = \{10.1111/j.1467-8640.2012.00460.x\}, \cr
url = \{https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1467-8640.2012.00460.x\}, \cr
eprint = \{https://onlinelibrary.wiley.com/doi/pdf/10.1111/j.1467-8640.2012.00460.x\}, \cr
year = \{2013\} \cr
\}
}
\examples{
\donttest{
lexicon_nrc()

# Custom directory
lexicon_nrc(dir = "data/")

# Deleting dataset
lexicon_nrc(delete = TRUE)

# Returning filepath of data
lexicon_nrc(return_path = TRUE)
}
}
\seealso{
Other lexicon: 
\code{\link{lexicon_afinn}()},
\code{\link{lexicon_bing}()},
\code{\link{lexicon_loughran}()},
\code{\link{lexicon_nrc_eil}()},
\code{\link{lexicon_nrc_vad}()}
}
\concept{lexicon}
\keyword{datasets}
