% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hexlogo.R
\name{create_hexlogo}
\alias{create_hexlogo}
\title{Generate hexagon logo from a tableHTML object.}
\usage{
create_hexlogo(
  save = TRUE,
  format = "html",
  file = "tableHTML_hexlogo.html",
  complete_html = FALSE,
  ...
)
}
\arguments{
\item{save}{A boolean when set to TRUE the logo will be saved in the specified format.}

\item{format}{A character string to specify the format of the output,
it accepts \code{'html'}, \code{'png'}, or \code{'jpeg'}.
Default is \code{'html'}.}

\item{file}{A character string to specify the name and path to the new file.
Should end with \code{'.html'}, \code{'.png'}, or \code{'.jpeg'}, 
depending on the selected format.}

\item{complete_html}{Either TRUE or FALSE. Defaults to FALSE. If TRUE then the <html> and <body>
tags are also added in the file.}

\item{...}{Further parameters to pass to webshot.}
}
\value{
The hexagon logo of the tableHTML package as a tableHTML object.

The output will be shown in the Viewer pane, and can be saved
either as an image or as an HTML.
}
\description{
The purpose of the function \code{create_hexlogo} is to generate the hexagon logo 
of the \code{tableHTML} package.
}
\details{
The function \code{create_hexlogo} will generate the hexagon logo 
of the \code{tableHTML} package.
}
\examples{
\dontrun{
create_hexlogo(save = FALSE)

create_hexlogo(format = 'jpeg',
            file = '~/exported_hexlogo.jpeg')
}
}
