% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editData_gui.r
\name{editData_gui}
\alias{editData_gui}
\title{Edit or View Data Frames}
\usage{
editData_gui(env = parent.frame(), savegui = NULL, data = NULL,
  name = NULL, edit = TRUE, debug = FALSE, parent = NULL)
}
\arguments{
\item{env}{environment in which to search for data frames.}

\item{savegui}{logical indicating if GUI settings should be saved in the environment.}

\item{data}{data.frame for instant viewing.}

\item{name}{character string with the name of the provided dataset.}

\item{edit}{logical TRUE to enable edit (uses \code{\link{gdf}}), FALSE to
view and enable sorting by clicking a column header (uses \code{\link{gtable}}).}

\item{debug}{logical indicating printing debug information.}

\item{parent}{widget to get focus when finished.}
}
\value{
TRUE
}
\description{
GUI to edit and view data frames.
}
\details{
Select a data frame from the drop-down to view or edit a dataset.
It is possible to save as a new dataframe. To enable sorting by clicking the
column headers the view mode must be used (i.e. edit = FALSE). There is an
option to limit the number of rows shown that can be used to preview large
datasets that may otherwise cause performance problems. Attributes of the
dataset can be views in a separate window.
}
\seealso{
\code{\link{trim_gui}}, \code{\link{cropData_gui}}, \code{\link{combine_gui}}
}
