% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/columns.r
\name{columns}
\alias{columns}
\title{Column Actions}
\usage{
columns(data, col1, col2 = NA, operator = "&", fixed = NA, target = NA,
  debug = FALSE)
}
\arguments{
\item{data}{a data frame.}

\item{col1}{character column name to perform action on.}

\item{col2}{character optional second column name to perform action on.}

\item{operator}{character to indicate operator: & concatenate, + add,
* multiply, - subtract, / divide.}

\item{fixed}{character or numeric providing the second operand if 'col2'
is not used.}

\item{target}{character to specify column name for result. Default is to
overwrite 'col1'. If not present it will be added.}

\item{debug}{logical to indicate if debug information should be printed.}
}
\value{
data frame.
}
\description{
Perform actions on columns.
}
\details{
Perform actions on columns in a data frame. There are five actions: concatenate,
add, multiply, subtract, divide. The selected action can be
performed on two columns, or one column and a fixed value. A target column
for the result is specified. NB! if the target column already exist it will
be overwritten, else it will be created. A common use is to create a unique
Sample.Name from the existing Sample.Name column and e.g. the File.Name or File.Time
columns. It can also be used to calculate the Amount from the Concentration.
}
\examples{
# Get a sample dataset.
data(set2)
# Add concatenate Sample.Name and Dye.
set2 <- columns(data=set2, col1="Sample.Name", col2="Dye")
# Multiply Height by 4.
set2 <- columns(data=set2, col1="Height", operator="*", fixed=4)
}

