% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.cem}
\alias{graph.cem}
\title{Clustering Expectation-Maximization for Graphs (graph.cem)}
\usage{
graph.cem(g, model, k, max_iter = 10, ncores = 1, bandwidth = "Sturges")
}
\arguments{
\item{g}{a list containing the graphs or their adjacency matrices to be
clustered.}

\item{model}{a string that indicates one of the following random graph
models: "ER" (Erdos-Renyi random graph), "GRG" (geometric random graph), "KR"
(k regular graph), "WS" (Watts-Strogatz model), and "BA" (Barabasi-Albert
model).}

\item{k}{an integer specifying the number of clusters.}

\item{max_iter}{the maximum number of expectation-maximization steps to execute.}

\item{ncores}{the number of cores to be used for the parallel processing. The
default value is 1.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges", "bcv", "ucv" and "SJ".
"bcv" is an abbreviation of biased cross-validation, while "ucv" means
unbiased cross-validation. "SJ"  implements the methods of Sheather & Jones
(1991) to select the bandwidth using pilot estimation of derivatives.}
}
\value{
a list containing three fields:
labels a vector of the same length of g containing the clusterization labels;
a vector containing the estimated parameters for the groups. It has the
length equals to \code{k};
}
\description{
\code{graph.cem} clusters graphs following an expectation-maximization algorithm based
on the Kullback-Leibler divergence between the spectral densities of the
graph and of the random graph model.
}
\examples{
 set.seed(42)
 g <- list()
 for(i in 1:2){
   g[[i]] <- igraph::sample_gnp(n=10, p=0.5)
 }
 for(i in 3:4){
   g[[i]] <- igraph::sample_gnp(n=10, p=1)
 }
 res <- graph.cem(g, model="ER", k=2, max_iter=1, ncores=1)
 res
}
\references{
Celeux, Gilles, and Gerard Govaert. "Gaussian parsimonious clustering
models." Pattern recognition 28.5 (1995): 781-793.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{graph.cem}
