% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/s3-sparsebnPath.R
\docType{class}
\name{sparsebnPath}
\alias{sparsebnPath}
\alias{is.sparsebnPath}
\alias{print.sparsebnPath}
\alias{summary.sparsebnPath}
\alias{plot.sparsebnPath}
\title{sparsebnPath class}
\usage{
sparsebnPath(x)

is.sparsebnPath(x)

\method{print}{sparsebnPath}(x, verbose = FALSE, ...)

\method{summary}{sparsebnPath}(object, ...)

\method{plot}{sparsebnPath}(x, labels = FALSE, ...)
}
\arguments{
\item{x}{A \code{list} or an object of type \code{sparsebnPath}. Should only be used internally.}

\item{verbose}{If \code{TRUE}, then each estimate in the solution path is printed separately. Do not use for
large graphs or large solution paths. (default = \code{FALSE})}

\item{...}{(optional) additional arguments.}

\item{object}{an object of type \code{sparsebnPath}}

\item{labels}{\code{TRUE} or \code{FALSE}. Whether or not to print out
labels with summary information for each plot in the solution path.}
}
\description{
Convenience wrapper class for solution paths of DAG learning algorithms: This class represents an entire
solution path of an algorithm. Its components are of type \code{\link{sparsebnFit}}. Also inherits
from \code{\link{list}}.
}
\details{
Each value of lambda in the (discrete) solution path corresponds to a single DAG estimate (see \href{https://jmlr.org/papers/v16/aragam15a.html}{Aragam and Zhou (2015)} for details).
Internally, this estimate is represented by a \code{\link{sparsebnFit}} object. The full solution
path is then represented as a \code{\link{list}} of \code{\link{sparsebnFit}} objects: This class is essentially a wrapper for this list.

Most methods for \code{\link{sparsebnPath}} objects simply apply \code{\link{lapply}} to the
object in question. The exceptions to this rule apply when the output will always be the same
for every component; e.g. \code{\link{num.nodes}} and \code{\link{num.samples}}.
}
\section{Methods}{

\code{\link{get.adjacency.matrix}}, \code{\link{get.lambdas}},
\code{\link{num.nodes}}, \code{\link{num.edges}}, \code{\link{num.samples}}
}

\examples{

\dontrun{
### Learn the cytometry network
library(sparsebn)
data(cytometryContinuous) # from the sparsebn package
cyto.data <- sparsebnData(cytometryContinuous[["data"]], type = "continuous")
cyto.learn <- estimate.dag(cyto.data)

### Inspect the output
class(cyto.learn)
print(cyto.learn)
plot(cyto.learn)
}

}
