% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\docType{class}
\name{PoisGammaDPUpdate}
\alias{PoisGammaDPUpdate}
\title{PoisGammaDPUpdate}
\format{Object of \code{\link{R6Class}} with methods for updating a \link{DirichletProcessNode} instance.}
\usage{
PoisGammaDPUpdate
}
\value{
Object of \code{\link{PoisGammaDPUpdate}}
}
\description{
This class implements a marginal Gibbs sampler for a Dirichlet process
prior on the mean of a Poisson distributed random variable, with a Gamma-distributed
base function.
}
\details{
The marginal Gibbs sampler is based on the description in Gelman et al. Bayesian Data
Analysis, 3rd edition, Chapter 23.

Please note that no checks are performed as to the suitability of this
algorithm for a particular \link{StochasticNode}.  It is up to the user
to use the correct update algorithm for the appropriate nodes.
}
\section{Methods}{

\describe{
  \item{\code{new(node)}}{constructor takes an instance of a \link{DirichletProcessNode} \code{node}}
  \item{\code{update()}}{when called, updates \code{node}}
}
}
\keyword{DAG}
\keyword{Dirichlet-process}
\keyword{node}

