% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_clusterstatus.R
\name{collection_clusterstatus}
\alias{collection_clusterstatus}
\title{Get cluster status}
\usage{
collection_clusterstatus(name = NULL, shard = NULL, raw = FALSE, ...)
}
\arguments{
\item{name}{(character) The collection name for which information is requested.
If omitted, information on all collections in the cluster will be returned.}

\item{shard}{(character) The shard(s) for which information is requested. Multiple
shard names can be specified as a character vector.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Fetch the cluster status including collections, shards, replicas,
configuration name as well as collection aliases and cluster properties.
}
\examples{
\dontrun{
solr_connect()
collection_clusterstatus()
res <- collection_clusterstatus()
res$responseHeader
res$cluster
res$cluster$collections
res$cluster$collections$gettingstarted
res$cluster$live_nodes
}
}

