% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadablePlot.R
\name{downloadablePlot}
\alias{downloadablePlot}
\title{Server-side logic for plot with download data button}
\usage{
downloadablePlot(input, output, session, plot, filename, content, ...)
}
\arguments{
\item{input, output, session}{standard \code{shiny} boilerplate.}

\item{plot}{A \code{ggplot2} object or a function or reactive that generates a plot.}

\item{filename}{A string of the filename, including extension, that the
user's web browser should default to when downloading the file; or a
function that returns such a string. (Reactive values and functions may be
used from this function.)}

\item{content}{A function that takes a single argument \code{file} that is a
file path (string) of a nonexistent temp file, and writes the content to
that file path. (Reactive values and functions may be used from this
function.)}

\item{...}{additional named arguments passed to \code{renderPlot}.}
}
\value{
No return value, called to generate server logic.
}
\description{
Download button appears on hover in top right.
}
\examples{
library(shiny)
library(shinyjs)
library(shinydlplot)
library(ggplot2)

ui <- fluidPage(
  useShinyjs(),
  downloadablePlotUI(id = 'iris_plot')
)

server <- function(input, output, session) {

  plot <- ggplot(iris, aes(x = Sepal.Length, y = Petal.Length)) + geom_point()

  callModule(downloadablePlot,
             id = 'iris_plot',
             plot = plot,
             filename = 'iris.csv',
             content = function(file) {write.csv(iris, file)})
}

\dontrun{shinyApp(ui, server)}


}
\seealso{
\code{\link{downloadablePlotUI}}, \code{\link{renderPlot}}.
}
