% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pairwise_comparison}
\alias{plot_pairwise_comparison}
\title{Plot Heatmap of Pairwise Comparisons}
\usage{
plot_pairwise_comparison(
  comparison_result,
  type = c("mean_scores_ratio", "pval")
)
}
\arguments{
\item{comparison_result}{A data.frame as produced by
\code{\link[=pairwise_comparison]{pairwise_comparison()}}}

\item{type}{character vector of length one that is either
"mean_scores_ratio" or "pval". This denotes whether to
visualise the ratio or the p-value of the pairwise comparison.
Default is "mean_scores_ratio".}
}
\description{
Creates a heatmap of the ratios or pvalues from a pairwise comparison
between models
}
\examples{
library(ggplot2)
scores <- score(example_quantile)
pairwise <- pairwise_comparison(scores, by = "target_type")
plot_pairwise_comparison(pairwise, type = "mean_scores_ratio") +
  facet_wrap(~target_type)
}
