% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_forecasts.R
\name{check_forecasts}
\alias{check_forecasts}
\title{Check forecasts}
\usage{
check_forecasts(data)
}
\arguments{
\item{data}{A data.frame or data.table with the predictions and observations.
For scoring using \code{\link[=score]{score()}}, the following columns need to be present:
\itemize{
\item \code{true_value} - the true observed values
\item \code{prediction} - predictions or predictive samples for one
true value. (You only don't need to provide a prediction column if
you want to score quantile forecasts in a wide range format.)}
For scoring integer and continuous forecasts a \code{sample} column is needed:
\itemize{
\item \code{sample} - an index to identify the predictive samples in the
prediction column generated by one model for one true value. Only
necessary for continuous and integer forecasts, not for
binary predictions.}
For scoring predictions in a quantile-format forecast you should provide
a column called \code{quantile}:
\itemize{
\item \code{quantile}: quantile to which the prediction corresponds
}

In addition a \code{model} column is suggested and if not present this will be
flagged and added to the input data with all forecasts assigned as an
"unspecified model").

You can check the format of your data using \code{\link[=check_forecasts]{check_forecasts()}} and there
are examples for each format (\link{example_quantile}, \link{example_continuous},
\link{example_integer}, and \link{example_binary}).}
}
\value{
A list with elements that give information about what \code{scoringutils}
thinks you are trying to do and potential issues.
\itemize{
\item \code{target_type} the type of the prediction target as inferred from the
input: 'binary', if all values in \code{true_value} are either 0 or 1 and values
in \code{prediction} are between 0 and 1, 'discrete' if all true values are
integers.
and 'continuous' if not.
\item \code{prediction_type} inferred type of the prediction. 'quantile', if there is
a column called 'quantile', else 'discrete' if all values in \code{prediction}
are integer, else 'continuous.
\item \code{forecast_unit} unit of a single forecast, i.e. the grouping that uniquely
defines a single forecast. This is assumed to be all
present columns apart from the following protected columns:
\code{c("prediction", "true_value", "sample", "quantile","range", "boundary")}.
It is important that you remove all unnecessary columns before scoring.
\item \code{rows_per_forecast} a data.frame that shows how many rows (usually
quantiles or samples there are available per forecast. If a forecast model
has several entries, then there a forecasts with differing numbers of
quantiles / samples.
\item \code{unique_values} A data.frame that shows how many unique values there are
present per model and column in the data. This doesn't directly show missing
values, but rather the maximum number of unique values across the whole data.
\item \code{warnings} A vector with warnings. These can be ignored if you know what
you are doing.
\item \code{errors} A vector with issues that will cause an error when running
\code{\link[=score]{score()}}.
\item \code{messages} A verbal explanation of the information provided above.
}
}
\description{
Function to check the input data before running
\code{\link[=score]{score()}}.

The data should come in one of three different formats:
\itemize{
\item A format for binary predictions (see \link{example_binary})
\item A sample-based format for discrete or continuous predictions
(see \link{example_continuous} and \link{example_integer})
\item A quantile-based format (see \link{example_quantile})
}
}
\examples{
check <- check_forecasts(example_quantile)
print(check)
check_forecasts(example_binary)
}
\seealso{
Function to move from sample-based to quantile format:
\code{\link[=sample_to_quantile]{sample_to_quantile()}}
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
\keyword{check-forecasts}
