% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{setCorrPlotType}
\alias{setCorrPlotType}
\title{Tells which type of correlation plot to use.}
\usage{
setCorrPlotType(id, corrPlotType)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{corrPlotType}{One of the available correlation plot types (Circles, Text).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which type of correlation plot to use.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     selectInput(
       "corrPlotTypeSelect", 
       "Correlation Plot Type:", 
       choices = list("Circles" = "Circles", "Text" = "Text"), 
       selected = "Circles"
     ),
     p("The selector controls the type of correlation to use"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris, zAxisDim = "Sepal.Length", continuousCS = "Plasma")
     })
     observeEvent(input$corrPlotTypeSelect, {
       scatterPlotMatrix::setCorrPlotType("spMatrix", input$corrPlotTypeSelect)
     })
   }

   shinyApp(ui, server)
 }

}
