% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Plotting.R
\name{DimPlot_LIGER}
\alias{DimPlot_LIGER}
\title{DimPlot LIGER Version}
\usage{
DimPlot_LIGER(
  liger_object,
  group_by = deprecated(),
  group.by = NULL,
  split_by = deprecated(),
  split.by = NULL,
  colors_use_cluster = NULL,
  colors_use_meta = NULL,
  pt_size = NULL,
  shuffle = TRUE,
  shuffle_seed = 1,
  reduction_label = "UMAP",
  reduction = NULL,
  aspect_ratio = NULL,
  label = TRUE,
  label_size = NA,
  label_repel = FALSE,
  label_box = FALSE,
  label_color = "black",
  combination = FALSE,
  raster = NULL,
  raster.dpi = c(512, 512),
  num_columns = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123
)
}
\arguments{
\item{liger_object}{\code{liger} liger_object.  Need to perform clustering before calling this function}

\item{group_by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{group.by}.}

\item{group.by}{Variable to be plotted.  If \code{NULL} will plot clusters from \code{liger@clusters} slot.
If \code{combination = TRUE} will plot both clusters and meta data variable.
If \code{combination = TRUE} will plot both clusters and meta data variable.}

\item{split_by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{split.by}.}

\item{split.by}{Variable to split plots by.}

\item{colors_use_cluster}{colors to use for plotting by clusters.  By default if number of levels plotted is
less than or equal to 36 will use "polychrome" and if greater than 36 will use "varibow" with shuffle = TRUE
both from \code{\link{DiscretePalette_scCustomize}}.}

\item{colors_use_meta}{colors to use for plotting by meta data (cell.data) variable.  By default if number
of levels plotted is less than or equal to 36 it will use "polychrome" and if greater than 36 will use
"varibow" with shuffle = TRUE both from DiscretePalette_scCustomize.}

\item{pt_size}{Adjust point size for plotting.}

\item{shuffle}{logical. Whether to randomly shuffle the order of points. This can be useful for crowded plots
if points of interest are being buried. (Default is TRUE).}

\item{shuffle_seed}{Sets the seed if randomly shuffling the order of points.}

\item{reduction_label}{What to label the x and y axes of resulting plots.  LIGER does not store name of
technique and therefore needs to be set manually.  Default is "UMAP". (only valid for
rliger < 2.0.0).}

\item{reduction}{specify reduction to use when plotting.  Default is current object
default reduction (only valid for rliger v2.0.0 or greater).}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{label}{logical.  Whether or not to label the clusters.  ONLY applies to plotting by cluster.  Default is TRUE.}

\item{label_size}{size of cluster labels.}

\item{label_repel}{logical.  Whether to repel cluster labels from each other if plotting by
cluster (if \code{group.by = NULL} or \verb{group.by = "cluster}).  Default is FALSE.}

\item{label_box}{logical.  Whether to put a box around the label text (uses \code{geom_text} vs \code{geom_label}).
Default is FALSE.}

\item{label_color}{Color to use for cluster labels.  Default is "black".}

\item{combination}{logical, whether to return patchwork displaying both plots side by side.  (Default is FALSE).}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{num_columns}{Number of columns in plot layout.  Only valid if \code{split.by != NULL}.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
A ggplot/patchwork object
}
\description{
Standard and modified version of LIGER's plotByDatasetAndCluster
}
\examples{
\dontrun{
DimPlot_LIGER(liger_object = obj_name, reduction_label = "UMAP")
}

}
\concept{liger_plotting}
