% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-amt.R
\name{stat_amt}
\alias{stat_amt}
\alias{geom_amt}
\title{Dosing/Amt geom/stat}
\usage{
stat_amt(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_amt(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
This returns a stat_amt in context of a ggplot2 plot
}
\description{
This is a dosing geom that shows the vertical lines where a dose occurs
}
\details{
Requires the following aesthetics:

\itemize{
\item x representing the x values, usually time
\item amt representing the dosing values;  They are missing or zero when no dose is given
}
}
\examples{

\donttest{ 
library(rxode2)
library(units)


## Model from RxODE tutorial
mod1 <-rxode2({
       KA=2.94E-01
       CL=1.86E+01
       V2=4.02E+01
       Q=1.05E+01
       V3=2.97E+02
       Kin=1
       Kout=1
       EC50=200
       C2 = centr/V2
       C3 = peri/V3
       d/dt(depot) =-KA*depot
       d/dt(centr) = KA*depot - CL*C2 - Q*C2 + Q*C3
       d/dt(peri)  =                    Q*C2 - Q*C3
       d/dt(eff)  = Kin - Kout*(1-C2/(EC50+C2))*eff
})

## These are making the more complex regimens of the rxode2 tutorial

## bid for 5 days
bid <- et(timeUnits="hr") \%>\%
      et(amt=10000,ii=12,until=set_units(5, "days"))

## qd for 5 days
qd <- et(timeUnits="hr") \%>\%
      et(amt=20000,ii=24,until=set_units(5, "days"))

## bid for 5 days followed by qd for 5 days

et <- seq(bid,qd) \%>\% et(seq(0,11*24,length.out=100));

bidQd <- rxSolve(mod1, et, addDosing=TRUE)

# by default dotted and under-stated
plot(bidQd, C2) + geom_amt(aes(amt=amt))

# of course you can make it a bit more visible

plot(bidQd, C2) + geom_amt(aes(amt=amt), col="red", lty=1, size=1.2)
}
}
