% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{defaults}
\alias{defaults}
\title{Default values passed to RandMat*}
\usage{
defaults(ncolX, paramList, cat.map)
}
\arguments{
\item{ncolX}{an integer denoting the number of columns in the design
matrix X.}

\item{paramList}{a list (possibly empty), to be populated with a set
of default values to be passed to a RandMat* function.}

\item{cat.map}{a list specifying which columns in X correspond to the
same one-of-K encoded feature. Each element of cat.map is a numeric
vector specifying the K column indices of X corresponding to the same
categorical feature after one-of-K encoding. All one-of-K encoded
features in X must come after the numeric features. The K encoded
columns corresponding to the same categorical feature must be placed
contiguously within X. The reason for specifying cat.map is to adjust
for the fact that one-of-K encoding cateogorical features results in
a dilution of numeric features, since a single categorical feature is
expanded to K binary features. If cat.map = NULL, then RerF assumes
all features are numeric (i.e. none of the features have been
one-of-K encoded).}
}
\value{
If \code{cat.map} is NULL, then
\itemize{
\item \code{p} is set to the number of columns of \code{X}
\item \code{d} is set to the ceiling of the square root of the number of columns of \code{X}
\item \code{sparsity}: if \eqn{\code{ncol(X)} \ge 10}, then sparsity is set
to 3 / \code{ncol{X}}, otherwise it is set to 1 / \code{ncol(X)}.
\item \code{prob} defaults to 0.5.
}
}
\description{
Given the parameter list and the categorical map this function
populates the values of the parameter list accoding to our "best"
known general use case parameters.
}
\keyword{internal}
