% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldChoiceMapping.R
\name{fieldChoiceMapping}
\alias{fieldChoiceMapping}
\alias{fieldChoiceMapping.character}
\alias{fieldChoiceMapping.redcapApiConnection}
\title{Splits a Field Choice Mapping Into a Two Column Matrix}
\source{
https://stackoverflow.com/questions/23961022/split-strings-on-first-and-last-commas
}
\usage{
fieldChoiceMapping(object, field_name, ...)

\method{fieldChoiceMapping}{character}(object, field_name, ...)

\method{fieldChoiceMapping}{redcapApiConnection}(object, field_name, ...)
}
\arguments{
\item{object}{May be either a \code{character(1)} with the content of the 
field choices (i.e. \code{meta_data$select_choices_or_calculations}), 
or a \code{redcapConnection} object.}

\item{field_name}{\code{character(1)} gives the field name for which to 
make the choice mapping.}

\item{...}{arguments to pass to other methods.}
}
\value{
Returns a matrix with two columns, \code{choice_value} and \code{choice_label}
}
\description{
Uses the string from the \code{select_choices_or_calculations}
  for the meta data to create a matrix of codes and their mapped 
  labels.
}
\author{
Benjamin Nutter, Shawn Garbett
}
