% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteRecords.R
\name{deleteRecords}
\alias{deleteRecords}
\alias{deleteRecords.redcapDbConnection}
\alias{deleteRecords.redcapApiConnection}
\title{Delete Records From a Project}
\usage{
deleteRecords(rcon, records, arms = NULL, ...)

\method{deleteRecords}{redcapDbConnection}(rcon, records, arms = NULL, ...)

\method{deleteRecords}{redcapApiConnection}(
  rcon,
  records,
  arms = NULL,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by 
\code{redcapConnection}.}

\item{records}{a vector of record names to be deleted.}

\item{arms}{\code{integerish}, the arm number of the arm in which the 
record(s) should be deleted. (This can only be used if the project is 
longitudinal with more than one arm.) NOTE: If the arm parameter is not 
provided, the specified records will be deleted from all arms in which 
they exist. Whereas, if arm is provided, they will only be deleted from 
the specified arm.}

\item{...}{Additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\value{
The number of deleted records.
}
\description{
Delete records from a project.  This is a destructive action that
  will result in deletion of any events and data associated with the arm.
  Data loss is non-reversible.  The user must have 'Delete Record' privileges
  in the database.
}
\section{REDCap API Documentation}{

This method allows you to delete one or more records from a project in a 
single API request.
}

\section{REDCap Version}{

At least 8.1.17+ (and likely some earlier versions)
}

\references{
Please refer to your institution's API documentation.
}
