% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteRecords.R
\name{deleteRecords}
\alias{deleteRecords}
\alias{deleteRecords.redcapApiConnection}
\title{Delete Records from a Project}
\usage{
deleteRecords(
  rcon,
  records,
  arm = NULL,
  instrument = NULL,
  event = NULL,
  repeat_instance = NULL,
  delete_logging = FALSE,
  ...
)

\method{deleteRecords}{redcapApiConnection}(
  rcon,
  records,
  arm = NULL,
  instrument = NULL,
  event = NULL,
  repeat_instance = NULL,
  delete_logging = FALSE,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{records}{\code{character} or \code{integerish}. Record ID's to be
returned.}

\item{arm}{\code{integerish}. the arm number of the arm in which the
record(s) should be deleted. This can only be used if the project is
longitudinal with more than one arm. If the arm parameter is not
provided, the specified records will be deleted from all arms in which
they exist. Whereas, if \code{arm} is provided, they will only be deleted from
the specified arm.}

\item{instrument}{\code{character(1)} Optional instrument to delete records from.}

\item{event}{\code{character(1)} Optional event to delete records from.}

\item{repeat_instance}{\code{numeric(1)} optional repeat instance to delete records from.}

\item{delete_logging}{\code{logical}. Should the logging for this record be
delete as well. Default to FALSE.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{deleteRecords} invisibly returns a character value giving the number of records deleted.
}
\description{
These methods enable the user to delete records from a project.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Delete records
deleteRecords(rcon, 
              records = c("1", "2"))

}

}
\seealso{
\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=importRecords]{importRecords()}}, \cr
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}
}
