% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable.R
\name{reactable}
\alias{reactable}
\title{Create an interactive data table}
\usage{
reactable(
  data,
  columns = NULL,
  columnGroups = NULL,
  rownames = NULL,
  groupBy = NULL,
  sortable = TRUE,
  resizable = FALSE,
  filterable = FALSE,
  searchable = FALSE,
  defaultColDef = NULL,
  defaultColGroup = NULL,
  defaultSortOrder = "asc",
  defaultSorted = NULL,
  pagination = TRUE,
  defaultPageSize = 10,
  showPageSizeOptions = FALSE,
  pageSizeOptions = c(10, 25, 50, 100),
  paginationType = "numbers",
  showPagination = NULL,
  showPageInfo = TRUE,
  minRows = 1,
  details = NULL,
  defaultExpanded = FALSE,
  selection = NULL,
  selectionId = NULL,
  defaultSelected = NULL,
  onClick = NULL,
  highlight = FALSE,
  outlined = FALSE,
  bordered = FALSE,
  borderless = FALSE,
  striped = FALSE,
  compact = FALSE,
  wrap = TRUE,
  showSortIcon = TRUE,
  showSortable = FALSE,
  class = NULL,
  style = NULL,
  rowClass = NULL,
  rowStyle = NULL,
  fullWidth = TRUE,
  width = "auto",
  height = "auto",
  theme = getOption("reactable.theme"),
  language = getOption("reactable.language"),
  elementId = NULL
)
}
\arguments{
\item{data}{A data frame or matrix.

Can also be a \code{\link[crosstalk:SharedData]{crosstalk::SharedData}} object that wraps a data frame.}

\item{columns}{Named list of column definitions. See \code{\link[=colDef]{colDef()}}.}

\item{columnGroups}{List of column group definitions. See \code{\link[=colGroup]{colGroup()}}.}

\item{rownames}{Show row names? Defaults to \code{TRUE} if the data has row names.

To customize the row names column, use \code{".rownames"} as the column name.}

\item{groupBy}{Character vector of column names to group by.

To aggregate data when rows are grouped, use the \code{aggregate} argument in \code{\link[=colDef]{colDef()}}.}

\item{sortable}{Enable sorting? Defaults to \code{TRUE}.}

\item{resizable}{Enable column resizing?}

\item{filterable}{Enable column filtering?}

\item{searchable}{Enable global table searching?}

\item{defaultColDef}{Default column definition used by every column. See \code{\link[=colDef]{colDef()}}.}

\item{defaultColGroup}{Default column group definition used by every column group.
See \code{\link[=colGroup]{colGroup()}}.}

\item{defaultSortOrder}{Default sort order. Either \code{"asc"} for ascending
order or \code{"desc"} for descending order. Defaults to \code{"asc"}.}

\item{defaultSorted}{Character vector of column names to sort by default.
Or to customize sort order, a named list with values of \code{"asc"} or \code{"desc"}.}

\item{pagination}{Enable pagination? Defaults to \code{TRUE}.}

\item{defaultPageSize}{Default page size for the table. Defaults to 10.}

\item{showPageSizeOptions}{Show page size options?}

\item{pageSizeOptions}{Page size options for the table. Defaults to 10, 25, 50, 100.}

\item{paginationType}{Pagination control to use. Either \code{"numbers"} for page
number buttons (the default), \code{"jump"} for a page jump, or \code{"simple"} to show
'Previous' and 'Next' buttons only.}

\item{showPagination}{Show pagination? Defaults to \code{TRUE} if the table has more
than one page.}

\item{showPageInfo}{Show page info? Defaults to \code{TRUE}.}

\item{minRows}{Minimum number of rows to show per page. Defaults to 1.}

\item{details}{Additional content to display when expanding a row. An R function
that takes a row index argument or a \code{\link[=JS]{JS()}} function that takes
a row info object as an argument. Can also be a \code{\link[=colDef]{colDef()}} to customize the
details expander column.}

\item{defaultExpanded}{Expand all rows by default?}

\item{selection}{Enable row selection? Either \code{"multiple"} or \code{"single"} for
multiple or single row selection.

To get the selected rows in Shiny, use \code{\link[=getReactableState]{getReactableState()}}.

To customize the selection column, use \code{".selection"} as the column name.}

\item{selectionId}{Shiny input ID for the selected rows. The selected rows are
given as a numeric vector of row indices, or \code{NULL} if no rows are selected.
\strong{NOTE:} \code{selectionId} will be deprecated in a future release.
Use \code{\link[=getReactableState]{getReactableState()}} to get the selected rows in Shiny instead.}

\item{defaultSelected}{A numeric vector of default selected row indices.}

\item{onClick}{Action to take when clicking a cell. Either \code{"expand"} to expand
the row, \code{"select"} to select the row, or a \code{\link[=JS]{JS()}} function that takes a
row info object, column info object, and table state object as arguments.}

\item{highlight}{Highlight table rows on hover?}

\item{outlined}{Add borders around the table?}

\item{bordered}{Add borders around the table and every cell?}

\item{borderless}{Remove inner borders from table?}

\item{striped}{Add zebra-striping to table rows?}

\item{compact}{Make tables more compact?}

\item{wrap}{Enable text wrapping? If \code{TRUE} (the default), long text will be
wrapped to multiple lines. If \code{FALSE}, text will be truncated to fit on one line.}

\item{showSortIcon}{Show a sort icon when sorting columns?}

\item{showSortable}{Show an indicator on sortable columns?}

\item{class}{Additional CSS classes to apply to the table.}

\item{style}{Inline styles to apply to the table. A named list or character string.

Note that if \code{style} is a named list, property names should be camelCased.}

\item{rowClass}{Additional CSS classes to apply to table rows. A character
string, a \code{\link[=JS]{JS()}} function that takes a row info object and table state object
as arguments, or an R function that takes a row index argument.}

\item{rowStyle}{Inline styles to apply to table rows. A named list, character
string, \code{\link[=JS]{JS()}} function that takes a row info object and table state object
as arguments, or an R function that takes a row index argument.

Note that if \code{rowStyle} is a named list, property names should be camelCased.
If \code{rowStyle} is a \code{\link[=JS]{JS()}} function, it should return a JavaScript object with
camelCased property names.}

\item{fullWidth}{Stretch the table to fill the full width of its container?
Defaults to \code{TRUE}.}

\item{width}{Width of the table in pixels. Defaults to \code{"auto"} for automatic sizing.

To set the width of a column, see \code{\link[=colDef]{colDef()}}.}

\item{height}{Height of the table in pixels. Defaults to \code{"auto"} for automatic sizing.}

\item{theme}{Theme options for the table, specified by
\code{\link[=reactableTheme]{reactableTheme()}}. Defaults to the global \code{reactable.theme} option.
Can also be a function that returns a \code{\link[=reactableTheme]{reactableTheme()}} or \code{NULL}.}

\item{language}{Language options for the table, specified by
\code{\link[=reactableLang]{reactableLang()}}. Defaults to the global \code{reactable.language} option.}

\item{elementId}{Element ID for the widget.}
}
\value{
A \code{reactable} HTML widget that can be used in R Markdown documents
and Shiny applications, or viewed from an R console.
}
\description{
\code{reactable()} creates a data table from tabular data with sorting
and pagination by default. The data table is an HTML widget that can be
used in R Markdown documents and Shiny applications, or viewed from an
R console.
}
\note{
See the \href{https://glin.github.io/reactable/}{online documentation} for
additional details and examples.
}
\examples{
# Basic usage
reactable(iris)

# Grouping and aggregation
reactable(iris, groupBy = "Species", columns = list(
  Sepal.Length = colDef(aggregate = "count"),
  Sepal.Width = colDef(aggregate = "mean"),
  Petal.Length = colDef(aggregate = "sum"),
  Petal.Width = colDef(aggregate = "max")
))

# Row details
reactable(iris, details = function(index) {
  htmltools::div(
    "Details for row: ", index,
    htmltools::tags$pre(paste(capture.output(iris[index, ]), collapse = "\n"))
  )
})

# Conditional styling
reactable(sleep, columns = list(
  extra = colDef(style = function(value) {
    if (value > 0) {
      color <- "green"
    } else if (value < 0) {
      color <- "red"
    } else {
      color <- "#777"
    }
    list(color = color, fontWeight = "bold")
  })
))

}
\seealso{
\itemize{
\item \code{\link[=renderReactable]{renderReactable()}} and \code{\link[=reactableOutput]{reactableOutput()}} for using reactable
in Shiny applications or interactive R Markdown documents.
\item \code{\link[=colDef]{colDef()}}, \code{\link[=colFormat]{colFormat()}}, and \code{\link[=colGroup]{colGroup()}} to customize columns.
\item \code{\link[=reactableTheme]{reactableTheme()}} and \code{\link[=reactableLang]{reactableLang()}} to customize the table.
}
}
