% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable.R
\name{reactable-shiny}
\alias{reactable-shiny}
\alias{reactableOutput}
\alias{renderReactable}
\title{Shiny bindings for reactable}
\usage{
reactableOutput(outputId, width = "auto", height = "auto",
  inline = FALSE)

renderReactable(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{A valid CSS unit (like \code{"100\%"}, \code{"400px"}, \code{"auto"})
or a number, which will be coerced to a string and have \code{"px"} appended.}

\item{inline}{Use an inline element for the table's container?}

\item{expr}{An expression that generates a \link{reactable} widget.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{\link[=quote]{quote()}})? This is useful
if you want to save an expression in a variable.}
}
\value{
\code{reactableOutput()} returns a \code{reactable} output element that can be
included in a Shiny UI.

\code{renderReactable()} returns a \code{reactable} render function that can be
assigned to a Shiny output slot.
}
\description{
Output and render functions for using reactable within Shiny
applications and interactive R Markdown documents.
}
\note{
See the \href{https://glin.github.io/reactable/articles/shiny-demo.html}{online demo}
for additional examples of using reactable in Shiny.
}
\examples{
# Run in an interactive R session
if (interactive()) {

library(shiny)
library(reactable)

ui <- fluidPage(
 titlePanel("reactable example"),
 reactableOutput("table")
)

server <- function(input, output, session) {
  output$table <- renderReactable({
   reactable(iris)
 })
}

shinyApp(ui, server)
}

}
