% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_techmix.R
\name{plot_techmix}
\alias{plot_techmix}
\title{Create a techmix plot}
\usage{
plot_techmix(data)
}
\arguments{
\item{data}{A data frame like the output of \code{prep_techmix()}.}
}
\value{
An object of class "ggplot".
}
\description{
Create a techmix plot
}
\examples{
# plot with `qplot_techmix()` parameters
data <- subset(
  market_share,
  scenario_source == "demo_2020" &
    sector == "power" &
    region == "global" &
    metric \%in\% c("projected", "corporate_economy", "target_sds")
) \%>\%
  prep_techmix(
    span_5yr = TRUE,
    convert_label = recode_metric_techmix,
    convert_tech_label = spell_out_technology
  )

plot_techmix(data)
}
\seealso{
\link{market_share}.
}
