% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_cli.R
\name{handler_cli}
\alias{handler_cli}
\title{Progression Handler: Progress Reported via 'cli' Progress Bars (Text) in the Terminal}
\usage{
handler_cli(
  show_after = 0,
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{show_after}{(numeric) Number of seconds to wait before displaying
the progress bar.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}}
and \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{cli} package.
}

\section{Appearance}{

Below are a few examples on how to use and customize this progress handler.
In all cases, we use \code{handlers(global = TRUE)}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers("cli")
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_cli-default.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_cli(format = "\{cli::pb_spin\} \{cli::pb_bar\} \{cli::pb_current\}/\{cli::pb_total\} \{cli::pb_status\}"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_cli-format-1.svg}}
}

\examples{
if (requireNamespace("cli", quietly = TRUE)) {
  handlers(handler_cli(format = "{cli::pb_spin} {cli::pb_bar} {cli::pb_percent} {cli::pb_status}"))
  with_progress({ y <- slow_sum(1:10) })
  print(y)
}
}
