% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedThreshold.R
\name{weightedThreshold}
\alias{weightedThreshold}
\title{A Shiny App for Model Evaluation and Weighted Threshold Optimization}
\usage{
weightedThreshold(object, ...)
}
\arguments{
\item{object}{A result from priorityelasticnet function with binomial model family.}

\item{...}{Additional arguments}
}
\value{
No return value. This function is used for side effects only, specifically to launch a Shiny application for model evaluation with weighted threshold optimization.
 The Shiny app provides an interactive interface to visualize model performance metrics and optimize thresholds for classification models based on user-defined criteria.
}
\description{
This function starts a Shiny application that enables users to interactively adjust the threshold for binary 
classification and view related metrics, the confusion matrix, ROC curve, and PR curve. 
The app also includes a feature for calculating the optimal threshold using a weighted version of Youden's J-statistic.
}
\details{
To calculate the optimal threshold, a weighted version of Youden's J-statistic (Youden, 1950) is used. 
The optimal cutoff is the threshold that maximizes the distance from the identity (diagonal) line. 
The function optimizes the metric (w * sensitivity + (1 - w) * specificity), where 'w' is the 
weight parameter adjusted using the second slider. After selecting the desired value on the optimal threshold slider, 
the user must press the "Set" button to update the threshold slider with the calculated optimal value. 
Metrics will then be automatically recalculated based on the user's selection. 
This function adapted from 'Monahov, A. (2021). Model Evaluation with Weighted Threshold Optimization 
(and the “mewto” R package). Available at SSRN 3805911.'
}
