% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.calibrate_thresholds}
\alias{print.calibrate_thresholds}
\title{Print method for \code{calibrate_thresholds} objects}
\usage{
\method{print}{calibrate_thresholds}(x, type1_range = c(0, 1), minimum_power = 0, ...)
}
\arguments{
\item{x}{an object of class 'calibrate_thresholds', usually returned by the
\code{calibrate_thresholds} function}

\item{type1_range}{a vector specifying the minimum and maximum acceptable
type I error. Specify c(0, 1) to return the full range of resulting type I
error. Defaults to c(0, 1)}

\item{minimum_power}{a numeric between 0 and 1 specifying the minimum
acceptable power. Specify 0 to return the full range of resulting power.
Defaults to 0.}

\item{...}{ignored}
}
\value{
Returns a tibble
}
\description{
By default prints only the res_summary table from an object of
class 'calibrate_thresholds'. The table can be limited to a range of type 1
error and a minimum value of power using the arguments 'type1_range' and
'minimum_power' respectively.
}
\examples{

set.seed(123)

cal_tbl1 <- calibrate_thresholds(
  p_null = 0.1,
  p_alt = 0.4,
  n = seq(5, 15, 5),
  N = 15,
  pp_threshold = c(0.85, 0.9),
  ppp_threshold = c(0.1, 0.2),
  S = 10,
  nsim = 10
  )

print(cal_tbl1)
print(cal_tbl1, type1_range = c(0.05, 0.1), minimum_power = 0.9)

}
