% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{scaledPrior}
\alias{scaledPrior}
\title{Compute scaled migration rate limits}
\usage{
scaledPrior(limits, model, Nref = NA)
}
\arguments{
\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{model}{a character, either 2pops", "Single" or "Parallel" indicating
which model was simulated.}

\item{Nref}{a numeric value indicating the effective population size of the
reference population.}
}
\value{
a matrix where each row is a different parameter. This matrix is
similar to the input argument \code{limits} but with added rows containing the
scaled migration rates.
}
\description{
Computes and adds scaled migration rates to a matrix with the limits of the
prior distributions.
}
\details{
Migration rates are scaled according to the size of the population receiving
the migrants and added to a matrix with the prior limits. The minimum and
maximum possible size of the population and of the migration rate are used to
compute the minimum and maximum possible values of the scaled migration
rates. This is performed for the three available models and according to the
specific model conformation.
}
\examples{
# create a vector of input parameters for a model with two populations
inputs <- c(Nref = c(25000, 25000), ratio = c(0.1, 3), pool = c(5, 250), seq = c(0.0001, 0.001),
split = c(0, 3), CW = c(1e-13, 1e-3), WC = c(1e-13, 1e-3), bT = c(0, 0.2))

# construct a matrix with the limits of the prior distribution
limits <- priorsMatrix(model = "2pops", inputParams = inputs)

# compute and add the prior limits of the scaled migration
scaledPrior(limits = limits, model = "2pops")

}
