% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{remove_typedarray_polyfill}
\alias{remove_typedarray_polyfill}
\title{Remove TypedArray polyfill}
\usage{
remove_typedarray_polyfill(p)
}
\arguments{
\item{p}{a plotly object}
}
\description{
By default, plotly.js' TypedArray polyfill is included as a dependency, so
printing "just works" in any context. Many users won't need this polyfill,
so this function may be used to remove it and thus reduce the size of the page.
}
\details{
The polyfill seems to be only relevant for those rendering plots 
via phantomjs and RStudio on some Windows platforms.
}
\examples{

p1 <- plot_ly()
p2 <- remove_typedarray_polyfill(p1)
t1 <- tempfile(fileext = ".html")
htmlwidgets::saveWidget(p1, t1)
file.info(t1)$size
htmlwidgets::saveWidget(p2, t1)
file.info(t1)$size
}
