% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-RCS.R
\name{rcsplot}
\alias{rcsplot}
\title{Plot restricted cubic splines curves}
\usage{
rcsplot(
  data,
  outcome = NULL,
  time = NULL,
  exposure = NULL,
  covariates = NULL,
  positive = NULL,
  group = NULL,
  knots = c(0.05, 0.35, 0.65, 0.95),
  knots.line = FALSE,
  ref.value = "k1",
  ref.line = TRUE,
  conf.int = TRUE,
  conf.level = 0.95,
  conf.type = c("shape", "line"),
  pvalue = TRUE,
  pvalue.digits = 3,
  pvalue.position = c(0.02, 0.98),
  pvalue.label.overall = "P for overall",
  pvalue.label.nonlinear = "P for nonlinear",
  fontsize = 12,
  fontfamily = "serif",
  linesize = 0.25,
  linecolor = "#0072B5FF",
  alpha = 0.1,
  xbreaks = NULL,
  ybreaks = NULL,
  xlab = "",
  ylab = "",
  explain = TRUE,
  ...
)
}
\arguments{
\item{data}{a data frame contain the columns of outcome, time, exposure,
covariates, and group.}

\item{outcome}{the name of outcome variable in the data.}

\item{time}{the name of time variable in the data, for Cox regressions.}

\item{exposure}{the name of exposure variable in the data.}

\item{covariates}{the names of covariate variables in the data.}

\item{positive}{in which positive of outcome variable to make the comparison.
By default, positive is automatically defined. If outcome is a factor variable,
then positive is defined as the highest level. If outcome is a numerical
variable, then positive is defined as the largest value.}

\item{group}{the name of group variable in the data.}

\item{knots}{location of knots, detail see \link{knot} function.}

\item{knots.line}{logical indicating whether or not to show the vertical lines
for the knots, default FALSE.}

\item{ref.value}{referrence value for the RCS curve, 'min' means using the
minimum value of esposure as a reference, 'median' uses the median, 'mean'
uses the mean, 'k1' uses the first knot. 'k2' uses the second knot, 'k3'
uses the third 'knot', and so on. In addition, you can directly set the
numerical vector as the reference value.}

\item{ref.line}{logical indicating whether or not to show the referrence line,
default TRUE.}

\item{conf.int}{logical indicating whether or not to draw confidence interval.
Defaults to TRUE.}

\item{conf.level}{the confidence level to use for the confidence interval if
conf.int = TRUE. Must be strictly greater than 0 and less than 1. Defaults to
0.95, which corresponds to a 95 percent confidence interval.}

\item{conf.type}{confidence interval type of 'shape' (default) or 'line'.}

\item{pvalue}{logical indicating whether or not to show P values,
include P for overall association and P for nonlinear, default TRUE.}

\item{pvalue.digits}{digits for P values, default 3.}

\item{pvalue.position}{position for P value, numeric vector of length two
(x-axis and y-axis).}

\item{pvalue.label.overall}{label for P value of overall.}

\item{pvalue.label.nonlinear}{label for P value of nonlinear.}

\item{fontsize}{font size, default 12.}

\item{fontfamily}{font family, default 'serif' (Times New Roman).}

\item{linesize}{line size, default 0.25.}

\item{linecolor}{line color, default '#0072B5FF'.}

\item{alpha}{alpha for the shape of confidence interval, default 0.1.}

\item{xbreaks}{breaks of x-axis.}

\item{ybreaks}{breaks of y-axis.}

\item{xlab}{label of x-axis.}

\item{ylab}{label of y-axis.}

\item{explain}{logical indicating whether or not to explain the figure,
default TRUE.}

\item{...}{further arguments.}
}
\value{
A ggplot2 object with class 'rcsplot' containing the attributes of 'title' and 'note'.
}
\description{
Drawing of restricted cubic spline (RCS) curves form a logistic
regression model or a  Cox proportional hazards regression model.
}
\examples{
# View data
head(cancer)

# RCS curves for a logistic regression model
rcsplot(data = cancer,
        outcome = "status",
        exposure = "age",
        covariates = c("sex", "race", "size", "metastasis"))

# RCS curves for a Cox regression model
rcsplot(data = cancer,
        outcome = "status",
        time = "time",
        exposure = "age",
        covariates = c("sex", "race", "size", "metastasis"))

# Unadjusted covariates
rcsplot(data = cancer,
        outcome = "status",
        time = "time",
        exposure = "age")

# By group
rcsplot(data = cancer,
        outcome = "status",
        time = "time",
        exposure = "age",
        covariates = c("sex", "race", "size", "metastasis"),
        group = "sex")

# Set 5 knots from 'kont' function
rcsplot(data = cancer,
        outcome = "status",
        time = "time",
        exposure = "age",
        covariates = c("sex", "race", "size", "metastasis"),
        knots = knot(5))

# Set the second knot as the referrence value
rcsplot(data = cancer,
        outcome = "status",
        time = "time",
        exposure = "age",
        covariates = c("sex", "race", "size", "metastasis"),
        knots = knot(5),
        ref.value = "k2")
}
\seealso{
\link{rcs}, \link{knot}
}
