% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_ll_CAR.R
\name{pin_ll}
\alias{pin_ll}
\title{Likelihood factorizations}
\usage{
pin_ll(param = NULL, numbuys = NULL, numsells = NULL,
  factorization = c("Lin_Ke", "EHO"))
}
\arguments{
\item{param}{\emph{numeric}: (named) vector of model parameters
(valid names: \code{'alpha'}, \code{'delta'}, \code{'epsilon_b'}, \code{'epsilon_s'}, \code{'mu'}), 
length must equal 5}

\item{numbuys}{\emph{numeric} vector of daily buys}

\item{numsells}{\emph{numeric} vector of daily sells}

\item{factorization}{\emph{character}: switch between EHO ('EHO') and Lin-Ke ('Lin_Ke') factorization}
}
\value{
\emph{numeric}: likelihood function value
}
\description{
Evaluates likelihood function either utilizing factorization by Easley et. al (2010)
or Lin and Ke (2011).
}
\details{
If names are not set for \code{param} or one or more of the vector names do not match the valid choices, they are internally set to
\code{'alpha'}, \code{'delta'}, \code{'epsilon_b'}, \code{'epsilon_s'}, \code{'mu'} (in this order). 
Vectors for \code{numbuys} and \code{numsells} need to have same length.
}
\references{
Easley, David et al. (2010) \cr
Factoring Information into Returns \cr
\emph{Journal of Financial and Quantitative Analysis}, Volume 45, Issue 2, pp. 293 - 309 \cr
\doi{10.1017/S0022109010000074}

Lin, Hsiou-Wei William and Ke, Wen-Chyan (2011) \cr
A computing bias in estimating the probability of informed trading \cr
\emph{Journal of Financial Markets}, Volume 14, Issue 4, pp. 625 - 640 \cr
\doi{10.1016/j.finmar.2011.03.001}
}

