% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_pipeline}
\alias{sagemaker_create_pipeline}
\title{Creates a pipeline using a JSON pipeline definition}
\usage{
sagemaker_create_pipeline(
  PipelineName,
  PipelineDisplayName = NULL,
  PipelineDefinition = NULL,
  PipelineDefinitionS3Location = NULL,
  PipelineDescription = NULL,
  ClientRequestToken,
  RoleArn,
  Tags = NULL,
  ParallelismConfiguration = NULL
)
}
\arguments{
\item{PipelineName}{[required] The name of the pipeline.}

\item{PipelineDisplayName}{The display name of the pipeline.}

\item{PipelineDefinition}{The JSON pipeline definition of the pipeline.}

\item{PipelineDefinitionS3Location}{The location of the pipeline definition stored in Amazon S3. If
specified, SageMaker will retrieve the pipeline definition from this
location.}

\item{PipelineDescription}{A description of the pipeline.}

\item{ClientRequestToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency of the operation. An idempotent operation completes no more
than one time.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role used by the pipeline to
access and create resources.}

\item{Tags}{A list of tags to apply to the created pipeline.}

\item{ParallelismConfiguration}{This is the configuration that controls the parallelism of the pipeline.
If specified, it applies to all runs of this pipeline by default.}
}
\description{
Creates a pipeline using a JSON pipeline definition.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_pipeline/} for full documentation.
}
\keyword{internal}
