% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset}
\alias{personalize_create_dataset}
\title{Creates an empty dataset and adds it to the specified dataset group}
\usage{
personalize_create_dataset(
  name,
  schemaArn,
  datasetGroupArn,
  datasetType,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name for the dataset.}

\item{schemaArn}{[required] The ARN of the schema to associate with the dataset. The schema defines
the dataset fields.}

\item{datasetGroupArn}{[required] The Amazon Resource Name (ARN) of the dataset group to add the dataset
to.}

\item{datasetType}{[required] The type of dataset.

One of the following (case insensitive) values:
\itemize{
\item Interactions
\item Items
\item Users
}}

\item{tags}{A list of
\href{https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html}{tags}
to apply to the dataset.}
}
\description{
Creates an empty dataset and adds it to the specified dataset group. Use \code{\link[=personalize_create_dataset_import_job]{create_dataset_import_job}} to import your training data to a dataset.

See \url{https://www.paws-r-sdk.com/docs/personalize_create_dataset/} for full documentation.
}
\keyword{internal}
