# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemakerfeaturestoreruntime_service.R
NULL

#' Retrieves a batch of Records from a FeatureGroup
#'
#' @description
#' Retrieves a batch of `Records` from a `FeatureGroup`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_batch_get_record/](https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_batch_get_record/) for full documentation.
#'
#' @param Identifiers &#91;required&#93; A list of `FeatureGroup` names, with their corresponding
#' `RecordIdentifier` value, and Feature name that have been requested to
#' be retrieved in batch.
#'
#' @keywords internal
#'
#' @rdname sagemakerfeaturestoreruntime_batch_get_record
sagemakerfeaturestoreruntime_batch_get_record <- function(Identifiers) {
  op <- new_operation(
    name = "BatchGetRecord",
    http_method = "POST",
    http_path = "/BatchGetRecord",
    paginator = list()
  )
  input <- .sagemakerfeaturestoreruntime$batch_get_record_input(Identifiers = Identifiers)
  output <- .sagemakerfeaturestoreruntime$batch_get_record_output()
  config <- get_config()
  svc <- .sagemakerfeaturestoreruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerfeaturestoreruntime$operations$batch_get_record <- sagemakerfeaturestoreruntime_batch_get_record

#' Deletes a Record from a FeatureGroup in the OnlineStore
#'
#' @description
#' Deletes a `Record` from a `FeatureGroup` in the `OnlineStore`. Feature Store supports both `SOFT_DELETE` and `HARD_DELETE`. For `SOFT_DELETE` (default), feature columns are set to `null` and the record is no longer retrievable by [`get_record`][sagemakerfeaturestoreruntime_get_record] or [`batch_get_record`][sagemakerfeaturestoreruntime_batch_get_record]. For` HARD_DELETE`, the complete `Record` is removed from the `OnlineStore`. In both cases, Feature Store appends the deleted record marker to the `OfflineStore` with feature values set to `null`, `is_deleted` value set to `True`, and `EventTime` set to the delete input `EventTime`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_delete_record/](https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_delete_record/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group to delete the record from.
#' @param RecordIdentifierValueAsString &#91;required&#93; The value for the `RecordIdentifier` that uniquely identifies the
#' record, in string format.
#' @param EventTime &#91;required&#93; Timestamp indicating when the deletion event occurred. `EventTime` can
#' be used to query data at a certain point in time.
#' @param TargetStores A list of stores from which you're deleting the record. By default,
#' Feature Store deletes the record from all of the stores that you're
#' using for the `FeatureGroup`.
#' @param DeletionMode The name of the deletion mode for deleting the record. By default, the
#' deletion mode is set to `SoftDelete`.
#'
#' @keywords internal
#'
#' @rdname sagemakerfeaturestoreruntime_delete_record
sagemakerfeaturestoreruntime_delete_record <- function(FeatureGroupName, RecordIdentifierValueAsString, EventTime, TargetStores = NULL, DeletionMode = NULL) {
  op <- new_operation(
    name = "DeleteRecord",
    http_method = "DELETE",
    http_path = "/FeatureGroup/{FeatureGroupName}",
    paginator = list()
  )
  input <- .sagemakerfeaturestoreruntime$delete_record_input(FeatureGroupName = FeatureGroupName, RecordIdentifierValueAsString = RecordIdentifierValueAsString, EventTime = EventTime, TargetStores = TargetStores, DeletionMode = DeletionMode)
  output <- .sagemakerfeaturestoreruntime$delete_record_output()
  config <- get_config()
  svc <- .sagemakerfeaturestoreruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerfeaturestoreruntime$operations$delete_record <- sagemakerfeaturestoreruntime_delete_record

#' Use for OnlineStore serving from a FeatureStore
#'
#' @description
#' Use for `OnlineStore` serving from a `FeatureStore`. Only the latest records stored in the `OnlineStore` can be retrieved. If no Record with `RecordIdentifierValue` is found, then an empty result is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_get_record/](https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_get_record/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group from which you want to retrieve a record.
#' @param RecordIdentifierValueAsString &#91;required&#93; The value that corresponds to `RecordIdentifier` type and uniquely
#' identifies the record in the `FeatureGroup`.
#' @param FeatureNames List of names of Features to be retrieved. If not specified, the latest
#' value for all the Features are returned.
#'
#' @keywords internal
#'
#' @rdname sagemakerfeaturestoreruntime_get_record
sagemakerfeaturestoreruntime_get_record <- function(FeatureGroupName, RecordIdentifierValueAsString, FeatureNames = NULL) {
  op <- new_operation(
    name = "GetRecord",
    http_method = "GET",
    http_path = "/FeatureGroup/{FeatureGroupName}",
    paginator = list()
  )
  input <- .sagemakerfeaturestoreruntime$get_record_input(FeatureGroupName = FeatureGroupName, RecordIdentifierValueAsString = RecordIdentifierValueAsString, FeatureNames = FeatureNames)
  output <- .sagemakerfeaturestoreruntime$get_record_output()
  config <- get_config()
  svc <- .sagemakerfeaturestoreruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerfeaturestoreruntime$operations$get_record <- sagemakerfeaturestoreruntime_get_record

#' Used for data ingestion into the FeatureStore
#'
#' @description
#' Used for data ingestion into the `FeatureStore`. The [`put_record`][sagemakerfeaturestoreruntime_put_record] API writes to both the `OnlineStore` and `OfflineStore`. If the record is the latest record for the `recordIdentifier`, the record is written to both the `OnlineStore` and `OfflineStore`. If the record is a historic record, it is written only to the `OfflineStore`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_put_record/](https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_put_record/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group that you want to insert the record into.
#' @param Record &#91;required&#93; List of FeatureValues to be inserted. This will be a full over-write. If
#' you only want to update few of the feature values, do the following:
#' 
#' -   Use [`get_record`][sagemakerfeaturestoreruntime_get_record] to
#'     retrieve the latest record.
#' 
#' -   Update the record returned from
#'     [`get_record`][sagemakerfeaturestoreruntime_get_record].
#' 
#' -   Use [`put_record`][sagemakerfeaturestoreruntime_put_record] to
#'     update feature values.
#' @param TargetStores A list of stores to which you're adding the record. By default, Feature
#' Store adds the record to all of the stores that you're using for the
#' `FeatureGroup`.
#'
#' @keywords internal
#'
#' @rdname sagemakerfeaturestoreruntime_put_record
sagemakerfeaturestoreruntime_put_record <- function(FeatureGroupName, Record, TargetStores = NULL) {
  op <- new_operation(
    name = "PutRecord",
    http_method = "PUT",
    http_path = "/FeatureGroup/{FeatureGroupName}",
    paginator = list()
  )
  input <- .sagemakerfeaturestoreruntime$put_record_input(FeatureGroupName = FeatureGroupName, Record = Record, TargetStores = TargetStores)
  output <- .sagemakerfeaturestoreruntime$put_record_output()
  config <- get_config()
  svc <- .sagemakerfeaturestoreruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerfeaturestoreruntime$operations$put_record <- sagemakerfeaturestoreruntime_put_record
