% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{.get_prediction_column_names}
\alias{.get_prediction_column_names}
\title{Obtain names of prediction columns for a fitted model or workflow}
\usage{
.get_prediction_column_names(x, syms = FALSE)
}
\arguments{
\item{x}{A fitted parsnip model (class \code{"model_fit"}) or a fitted workflow.}

\item{syms}{Should the column names be converted to symbols? Defaults to \code{FALSE}.}
}
\value{
A list with elements \code{"estimate"} and \code{"probabilities"}.
}
\description{
\code{\link[=.get_prediction_column_names]{.get_prediction_column_names()}} returns a list that has the names of the
columns for the primary prediction types for a model.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
library(modeldata)
data("two_class_dat")

levels(two_class_dat$Class)
lr_fit <- logistic_reg() |> fit(Class ~ ., data = two_class_dat)

.get_prediction_column_names(lr_fit)
.get_prediction_column_names(lr_fit, syms = TRUE)
\dontshow{\}) # examplesIf}
}
