% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_mixer.r
\name{make_colors}
\alias{make_colors}
\alias{make_edges_colors}
\alias{make_vertex_colors}
\title{Create a vector of colors for vertices and edges}
\usage{
make_colors(dat, categorical = FALSE, color_map = grDevices::hcl.colors)

make_edges_colors(x, eattr, ...)

make_vertex_colors(x, vattr, ...)
}
\arguments{
\item{dat}{A vector of data to generate the color from.}

\item{categorical}{Logical. When \code{TRUE} sets the colors as categories.}

\item{color_map}{A function to generate a palette.}

\item{x}{A graph of class \code{network} or \code{igraph}.}

\item{...}{Further arguments passed to \code{make_colors}.}

\item{vattr, eattr}{Character. Names of either vertex or edge variables to be
used for generating the colors.}
}
\value{
A vector of colors with the attribute \code{color_map}. The color map used
to generate the colors.
}
\description{
Using \code{vertex}/\code{edge} attributes, these functions return vectors of colors
that can be used either during the creation of the \link{nplot} object, or
afterwards when changing \code{gpar} (graphical parameter) values with \link{set_gpar}.
}
\details{
If no attribute is provided, then by defaul the colors are set according to
indegree.

\code{x} can be either a graph of class \code{igraph} or \code{network}.
}
\examples{

data(UKfaculty, package="igraphdata")
col <- make_vertex_colors(UKfaculty, "Group")

if (require(magrittr)) {

  nplot(UKfaculty) \%>\%
    set_vertex_gpar("core", fill = col, col=col) \%>\%
    set_vertex_gpar("frame", fill = col, col=col, alpha=.7) \%>\%
    set_edge_gpar(col="gray50", fill="gray50", alpha=.5)
}
}
