% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{model.matrix.cmp}
\alias{model.matrix.cmp}
\title{Extract the Design Matrix from a COM-Poisson Model Fit}
\usage{
\method{model.matrix}{cmp}(object, ...)
}
\arguments{
\item{object}{an object class 'cmp' object, obtained from a call to \code{glm.cmp}}

\item{...}{other arguments passed to or from other methods  (currently unused).}
}
\value{
The method will return the saved \code{\link{model.matrix}} used when fitting the cmp model.
}
\description{
Extract the Design Matrix from a COM-Poisson Model Fit
}
\examples{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
model.matrix(M.attendance)

\donttest{
data(sitophilus)
M.sit <- glm.cmp(formula = ninsect ~ extract, formula_nu = ~extract, data = sitophilus)
model.matrix(M.sit)
}
}
