% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z.R
\name{logZ}
\alias{logZ}
\title{Calculate the Normalizing Constant in log scale for COM-Poisson distribution}
\usage{
logZ(log_lambda, nu, summax = 100)
}
\arguments{
\item{log_lambda}{rate parameter in log scale.}

\item{nu}{dispersion parameter, straightly positive.}

\item{summax}{maximum number of terms to be considered in the truncated sum.}
}
\description{
A function to approximate the normalizing constant for COM-Poisson distributions via
truncation. The standard COM-Poisson parametrization is being used here.
}
\details{
As of version 0.2.0 of this package, \code{logZ} will supersede \code{Z} for calculating
the normalizing constant. \code{logZ} utilised a method that can calculate
\code{log(exp(logx) + exp(logy))} in a somewhat numerically stable way.

This function was originally purposed in the \code{cmpreg} package of Ribeiro Jr,
Zeviani & Demétrio (2019).
}
\references{
Ribeiro Jr, E. E., Zeviani, W. M., Demétrio, C. G. B. (2019) \code{cmpreg}:
Reparametrized COM-Poisson Regression Models. R package version 0.0.1.
}
