% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMP_Expected_Values.R
\name{comp_expected_values}
\alias{comp_expected_values}
\alias{comp_mean_logfactorialy}
\alias{comp_mean_ylogfactorialy}
\alias{comp_means}
\alias{comp_variances}
\alias{comp_variances_logfactorialy}
\title{Functions to Compute Various Expected Values for the COM-Poisson Distribution}
\usage{
comp_mean_logfactorialy(lambda, nu, log.Z, summax = 100)

comp_mean_ylogfactorialy(lambda, nu, log.Z, summax = 100)

comp_means(lambda, nu, log.Z, summax = 100)

comp_variances(lambda, nu, log.Z, summax = 100)

comp_variances_logfactorialy(lambda, nu, log.Z, summax = 100)
}
\arguments{
\item{lambda, nu, }{rate and dispersion  parameters. Must be positives.}

\item{log.Z, }{an optional vector specifying normalizing constant Z in log scale.}

\item{summax}{maximum number of terms to be considered in the truncated sum. The
default is to sum to 100.}
}
\value{
\code{comp_mean_logfactorialy} gives the mean of \emph{log(Y!)}.

\code{comp_mean_ylogfactorialy} gives the mean of \emph{ylog(Y!)}.

\code{comp_means} gives the mean of \emph{Y}.

\code{comp_variances} gives the variance of \emph{Y}.

\code{comp_variances_logfactorialy} gives the variance of \emph{log(Y!)}.
}
\description{
Functions to approximate the various expected values for the COM-Poisson distribution
via truncation.  The standard COM-Poisson parametrization is being used here.
The lambda and nu values are recycled to match the length
of the longer one and that would determine the length of the results.
}
