% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.marginaleffects}
\alias{plot.marginaleffects}
\title{Point-range plot of average marginal effects}
\usage{
\method{plot}{marginaleffects}(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An object produced by the \code{marginaleffects} function.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int=TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A \code{ggplot2} object
}
\description{
Uses the \code{ggplot2} package to draw a point-range plot of the average marginal effects computed by \code{tidy}.
}
\details{
The \code{tidy} function calculates average marginal effects by taking the mean
of all the unit-level marginal effects computed by the \code{marginaleffects}
function.
}
\examples{
mod <- glm(am ~ hp + wt, data = mtcars)
mfx <- marginaleffects(mod)
plot(mfx)

}
