% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{alert_rules}
\alias{alert_rules}
\title{Create set of alert rules}
\usage{
alert_rules(...)
}
\arguments{
\item{...}{alerts to apply to the time series}
}
\value{
An \code{alert_rules} object
}
\description{
Specify which alert rules should be run on the time series
}
\examples{
# alert if any values are NA
# or if all values are zero
ars <- alert_rules(
  alert_missing(extent_type = "any", extent_value = 1),
  alert_equals(extent_type = "all", rule_value = 0)
)

# alert if any values are over 100, but only for certain antibiotics
ars <- alert_rules(
  alert_above(
    extent_type = "any", extent_value = 1, rule_value = 100,
    items = list("Antibiotic" = c("Coamoxiclav", "Gentamicin"))
  )
)

# alert if any values are over 100, but only for SITE1,
# and only for certain antibiotics
ars <- alert_rules(
  alert_above(
    extent_type = "any", extent_value = 1, rule_value = 100,
    items = list(
      "Location" = "SITE1",
      "Antibiotic" = c("Coamoxiclav", "Gentamicin")
    )
  )
)

}
\seealso{
\code{\link[=alert_rule_types]{alert_rule_types()}}
}
