% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMeasure.R
\name{runMeasure}
\alias{runMeasure}
\title{Run and Measure Code}
\usage{
runMeasure(code, graph = inferGraph(code), envir = globalenv(),
  timer = Sys.time)
}
\arguments{
\item{code}{to be passed into \code{\link{inferGraph}}}

\item{graph}{object of class \code{DependGraph}}

\item{envir}{environment to evaluate the code in}

\item{timer}{function that returns a timestamp.}
}
\value{
graph object of class \code{MeasuredDependGraph}
}
\description{
Will export this once I the full pipeline works.
}
\details{
Run the serial code in the task graph and measure how long each expression
takes to run as well as the object sizes of each variable that can
possibly be transferred.

This does naive and biased timing since it doesn't account for the
overhead in evaluating a single expression. However, this is fine for
this application since the focus is on measuring statements that take at
least on the order of 1 second to run.
}
