% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological_kernels.R
\name{sw.kernel}
\alias{sw.kernel}
\title{Persistence Sliced Wasserstein Kernel (SWK)}
\usage{
sw.kernel(d1, d2 = NULL, h, dimension, M = 10)
}
\arguments{
\item{d1}{A persistence diagram (matrix with 3 col where the first one is the dimension, the second is the birth-time and the third is the death-time) or a list of diagrams}

\item{d2}{A persistence diagram (matrix with 3 col where the first one is the dimension, the second is the birth-time and the third is the death-time).}

\item{h}{bandwidth of the kernel}

\item{dimension}{The dimension of the topological feature (0 for connected components, 1 for cycles etc)}

\item{M}{number of directions on which to approximate the Sliced Wasserstein Distance}
}
\value{
If \code{d1} is a list of Persistence Diagrams, this function returns a matrix whose (i,j) entry is the SWK computed in (\code{d1}[[i]], \code{d2}[[j]]),
otherwise it returns the value for the SWK computed in (\code{d1}, \code{d2})
}
\description{
Computes the Persistence Sliced Wasserstein Kernel (SWK) between persistence diagrams.
}
\examples{
diag1 <- matrix(c(1,1,1,0,2,3,2,2.5,4), ncol = 3, byrow = FALSE)
diag2 <- matrix(c(1,1,0,1,1,2), ncol = 3, byrow = FALSE)
sw.kernel(d1 = diag1, d2 = diag2, h = 1, dimension = 1)
}
\references{
\insertRef{carriere2017sliced}{kernelTDA}
}
\author{
Tullia Padellini
}
