% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_categorical}
\alias{random_categorical}
\title{Draws samples from a categorical distribution.}
\usage{
random_categorical(logits, num_samples, dtype = "int32", seed = NULL)
}
\arguments{
\item{logits}{2-D Tensor with shape (batch_size, num_classes). Each row
should define a categorical distibution with the unnormalized
log-probabilities for all classes.}

\item{num_samples}{Int, the number of independent samples to draw for each
row of the input. This will be the second dimension of the output
tensor's shape.}

\item{dtype}{Optional dtype of the output tensor.}

\item{seed}{An R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{\link[=random_seed_generator]{random_seed_generator()}}.}
}
\value{
A 2-D tensor with (batch_size, num_samples).
}
\description{
This function takes as input \code{logits}, a 2-D input tensor with shape
(batch_size, num_classes). Each row of the input represents a categorical
distribution, with each column index containing the log-probability for a
given class.

The function will output a 2-D tensor with shape (batch_size, num_samples),
where each row contains samples from the corresponding row in \code{logits}.
Each column index contains an independent samples drawn from the input
distribution.
}
\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
